##################################################################
##################################################################
# Italian Leaders
##################################################################
##################################################################

use "C:\Users\Luigi\Documents\My Dropbox\SISP twitter\NewMedia&Society\Italy_Leaders.dta", clear

encode leader, gen(code)

gen MV = _n
tab code
sort  code MV
by code: gen MV2 = _n

sort code
by code: pwcorr mannheimer sett_perc_positivi, sig

# probabile che in paper sbagliato a mettere il valore della s.d
gen diff= mannheimer-sett_perc_positivi

egen mean_total_diff = mean(diff)
egen sd_total_diff = sd(diff)

sort leader
by leader: egen mean_diff =mean(diff)
by leader: egen sd_diff =sd(diff)

mean mean_diff sd_diff, over(code)

sort leader
by leader: egen mean_mannheimer = mean(mannheimer)

sort leader
by leader: egen mean_mese_perc_positivi = mean(mese_perc_positivi)

sort leader
by leader: egen mean_sett_perc_positivi = mean(sett_perc_positivi)

mean mean_mannheimer mean_mese_perc_positivi mean_sett_perc_positivi, over(code)

gen ctrl1 = mannheimer-mese_perc_positivi if mese_perc_positivi!=.
gen ctrl2 = mannheimer-sett_perc_positivi if sett_perc_positivi!=.

gen ctrl1_ab = abs(mannheimer-mese_perc_positivi) if mese_perc_positivi!=.
gen ctrl2_ab = abs(mannheimer-sett_perc_positivi) if sett_perc_positivi!=.

sort MV2
by MV2: egen mean_ctrl1 = mean(ctrl1) 

sort MV2
by MV2: egen mean_ctrl2 = mean(ctrl2)

sort MV2
by MV2: egen mean_ctrl1_ab = mean(ctrl1_ab) 

sort MV2
by MV2: egen mean_ctrl2_ab = mean(ctrl2_ab)

mean mean_ctrl1 mean_ctrl2
mean ctrl1, over(code)
mean ctrl2, over(code)

mean mean_ctrl1_ab mean_ctrl2_ab
mean ctrl1_ab, over(MV2)
mean ctrl2_ab, over(MV2)

mean mean_ctrl1_ab mean_ctrl2_ab if MV2!=4

sort MV2
mean ctrl1, over(MV2) 
sort MV2
mean ctrl2, over(MV2) 

label define date 1 "13-Jan-11" 2 "20-Jan-11" 3 "31-Mar-11" 4 "21-Apr-11" 5 "25-May-11" 6 "8-Sept-11" 7 "20-Oct-11"
label values MV2 date

gen line0 = 0

twoway (line mean_ctrl1 MV2) (line mean_ctrl2 MV2), ///
ytitle("Difference in perception", size(3))   ///
xtitle(Temporal Observations) legend(size(3) label(1 "Considering monthly CR")  label(2 "Considering weekly CR")  region(lcolor(white))) ///
xsca(titlegap(2)) ysca(titlegap(2)) scheme(s2mono) graphregion(fcolor(white)) ///
xlabel(1 "13-Jan-11"  2 "20-Jan-11" 3 "31-Mar-11" 4 "21-Apr-11" 5 "25-May-11" 6 "8-Sept-11" 7 "20-Oct-11", angle(45) labsize(medium))

twoway (line mean_ctrl1_ab MV2) (line mean_ctrl2_ab MV2), ///
ytitle("Absoloute Difference in perception", size(3))   ///
xtitle(Temporal Observations) legend(size(3) label(1 "Considering monthly CR")  label(2 "Considering weekly CR")  region(lcolor(white))) ///
xsca(titlegap(2)) ysca(titlegap(2)) scheme(s2mono) graphregion(fcolor(white)) ///
xlabel(1 "13-Jan-11"  2 "20-Jan-11" 3 "31-Mar-11" 4 "21-Apr-11" 5 "25-May-11" 6 "8-Sept-11" 7 "20-Oct-11", angle(45) labsize(medium))

twoway (line mean_ctrl1_ab MV2) (line mean_ctrl2_ab MV2), ///
ytitle("Absoloute Difference in perception", size(3))   ///
xtitle(Temporal Observations) legend(size(3) label(1 "Considering monthly posts")  label(2 "Considering weekly posts")  region(lcolor(white))) ///
xsca(titlegap(2)) ysca(titlegap(2)) scheme(s2mono) graphregion(fcolor(white)) ///
xlabel(1 "13-Jan-11"  2 "20-Jan-11" 3 "31-Mar-11" 4 "21-Apr-11" 5 "25-May-11" 6 "8-Sept-11" 7 "20-Oct-11", angle(45) labsize(medium))

twoway (line mean_ctrl2_ab MV2), ///
ytitle("MAE", size(3))   ///
xtitle(Temporal Observations) legend(size(3) label(1 "Considering weekly posts")   region(lcolor(white))) ///
xsca(titlegap(2)) ysca(titlegap(2)) scheme(s2mono) graphregion(fcolor(white)) ///
xlabel(1 "13-Jan-11"  2 "20-Jan-11" 3 "31-Mar-11" 4 "21-Apr-11" 5 "25-May-11" 6 "8-Sept-11" 7 "20-Oct-11", angle(45) labsize(medium))

twoway (line mean_ctrl2_ab MV2), ///
ytitle("MAE", size(3))   ///
xtitle(Temporal Observations) legend(size(3) label(1 "Considering weekly posts")   region(lcolor(white))) ///
xsca(titlegap(2)) ysca(titlegap(2)) scheme(s2mono) graphregion(fcolor(white)) ///
xlabel(1 "13-Jan-11 (1075 tweets)"  2 "20-Jan-11 (2882 tweets)" 3 "31-Mar-11 (2413 tweets)" 4 "21-Apr-11 (3097 tweets)" ///
 5 "26-May-11 (5091 tweets)" 6 "8-Sept-11 (6793 tweets)" 7 "20-Oct-11 (10454 tweets)", angle(75) labsize(small))

##################################################################
##################################################################
# French Legislative election first round
##################################################################
##################################################################

use "C:\Users\Luigi\Documents\My Dropbox\SISP twitter\NewMedia&Society\French Legislative Election First Round.dta", clear

drop if district==. 
drop if district==9999

reg MAE c.n_tweet c.abstent 
reg MAE c.n_tweet c.abstent votes_fn  votes_fdg incumb 
reg MAE c.n_tweet##c.abstent votes_fn  votes_fdg incumb
margins, dydx(n_tweet) at (abstent = (40 (5) 55))

reg MAE c.n_tweet##c.abstent votes_fn  votes_fdg incumb 
ereturn list

matrix list e(b)
matrix list e(V)
matrix b=e(b)
matrix V=e(V)

scalar b1=b[1,1]
scalar b3=b[1,3]

scalar varb1=V[1,1]
scalar varb3=V[3,3]

scalar covb1b3=V[1,3]

scalar list b1 b3 varb1 varb3 covb1b3

gen MV = (_n-1)+40
replace MV=. if MV>54
tab MV

gen conb=b1+b3*MV
gen conse=sqrt(varb1+varb3*(MV*MV)+2*covb1b3*MV)
gen a=1.68*conse
gen upper=conb+a
gen lower=conb-a

rename upper diff_hi
rename lower diff_lo
rename conb diff_hat

gen line0 = 0

twoway (hist abstention, percent yaxis(2) lwidth(vvthin) lcolor(white) bin(20)) ///
(line line0 MV, clwidth(medium) clcolor(blue) clpattern(solid)  clcolor(black) yaxis(1) ) ///
(line diff_hat MV, clwidth(medium) clcolor(blue) clcolor(black) yaxis(1)) ///
(line diff_lo MV, clpattern(dash) clwidth(thin) clcolor(black) yaxis(1)) ///
(line diff_hi MV, clpattern(dash) clwidth(thin) clcolor(black) yaxis(1)) ///
, yscale(alt axis(2)) yscale(alt axis(1))  xlabel(40 (5) 55, labsize(3))  yscale(noline) xscale(noline) ///
legend(size(3) col(1) order(4) label(4 "90% Confidence Interval") label(5 " ") region(lcolor(white))) ///
xtitle("Abstention (%)") ytitle("Marginal Effect of Number of Tweets", axis(1) size(3)) ytitle("Distribution of Abstentions across districts (%)", axis(2) size(3)) ///
xsca(titlegap(2)) ysca(titlegap(2) axis(1)) ysca(titlegap(2) axis(2)) scheme(s2mono) graphregion(fcolor(white))

